// FormDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sdobjects_demo.h"
#include "FormDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFormDlg dialog

CFormDlg::CFormDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFormDlg::IDD, pParent)
	,_selector(&g_conn)
{
	//{{AFX_DATA_INIT(CFormDlg)
	_order_date = _T("");
	_order_number = _T("");
	_payment_terms = _T("");
	_quantity = 0;
	_store_id = _T("");
	_title_id = _T("");
	//}}AFX_DATA_INIT

	// here we simply set our select
	// statement for this dialog...
	_selector = "SELECT stor_id,ord_num,ord_date,qty,payterms,title_id from sales";

	// ... and call the selector's
	// execute function to create
	// the rowset
	_selector.execute();
}


void CFormDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFormDlg)
	DDX_Text(pDX, IDC_ORDDATE, _order_date);
	DDX_Text(pDX, IDC_ORDNUM, _order_number);
	DDX_Text(pDX, IDC_PAYTERMS, _payment_terms);
	DDX_Text(pDX, IDC_QTY, _quantity);
	DDX_Text(pDX, IDC_STORID, _store_id);
	DDX_Text(pDX, IDC_TITLEID, _title_id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFormDlg, CDialog)
	//{{AFX_MSG_MAP(CFormDlg)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_BN_CLICKED(IDC_NEXT, OnNext)
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	ON_BN_CLICKED(IDC_INSERT, OnInsert)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFormDlg message handlers

void CFormDlg::OnClear() 
{
	_order_date = _T("");
	_order_number = _T("");
	_payment_terms = _T("");
	_quantity = 0;
	_store_id = _T("");
	_title_id = _T("");

	UpdateData(FALSE);
}

void CFormDlg::OnDelete() 
{
	// first lets update our
	// dialog variables so we
	// can build our where clause
	UpdateData(TRUE);

	// an sdo_deleter object takes
	// the a pointer to the sdo_connection
	// object, and the name of the table as
	// parameters

	// NOTE TO MS SQL SERVER USERS:
	// since Microsoft SQL Server ODBC has an
	// inherent limitation in that you cannot
	// issue a command to the database when there
	// is an open rowset, we'll have to open a
	// *NEW* connection and pass that object to
	// our sdo_deleter. With a database like
	// Oracle, you would just pass the main
	// sdo_connection object to the deleter.
	
	sdo_connection temp_connection;
	temp_connection.open_session("SQL_Pubs","sa","");

	sdo_deleter deleter(&temp_connection,"sales");

	// create an sdo_where object so we can
	// pass the primary key values that specify
	// this particular record.
	sdo_where where;
	where.Format(
		"stor_id='%s' AND ord_num='%s' AND title_id='%s'"
		,_store_id
		,_order_number
		,_title_id
		);

	// insert the where clause into the deleter
	deleter<<where;

	// now execute the statement on the connection
	deleter.execute();

	// that's all there is to it! but to be 
	// nice, we can force a refresh of the view
	OnRefresh();
}

void CFormDlg::OnNext() 
{
	// make sure our selector is in a
	// valid state and a rowset exists
	if(!_selector.is_valid_state())
		return;

	// let's request a rowset from the
	// selector. the selector will maintain
	// the position into the current rowset
	// and initialize the new one at the
	// proper location. ( even after the
	// rowset goes out of scope
	sdo_rowset rowset = _selector.rowset();
	
	// as long as there are more rows,
	// we can step through them with
	// either the post or pre-increment
	// operators
	if(rowset++)
	{
		// all basic datatypes are overloaded, including
		// TIMESTAMP_STRUCT & sdo_date_time. It is
		// your responsibility to make sure the order
		// of insertion matches the column order in the
		// select statement

		// create an sdo_date_time object to properly
		// retrieve the data from the sales.ord_date
		// column
		sdo_date_time date_time;

		// shift all data into their respective variables
		rowset>>_store_id>>_order_number>>date_time
			>>_quantity>>_payment_terms>>_title_id;
	
		// choose a date format for the sdo_date_time
		// object. There are 10 different format types
		date_time.set_format(USA_DATE);

		// retrieve the date info into our CString variable
		date_time.get(_order_date);

		// update screen from variables
		UpdateData(FALSE);

		// tell me that wasn't easy! if you've ever coded
		// all this stuff using the ODBC API, you can
		// really appreciate this.
	}
}

void CFormDlg::OnRefresh() 
{
	// all we need to do is re-execute
	// our _selector object. it will
	// take care of freeing all resources
	// and getting a new rowset
	_selector.execute();

	// now, get the first row
	OnNext();
}

void CFormDlg::OnUpdate() 
{
	// first lets update our
	// dialog variables
	UpdateData(TRUE);

	// an sdo_updater object takes
	// the a pointer to the sdo_connection
	// object, and the name of the table as
	// parameters

	// NOTE TO MS SQL SERVER USERS:
	// since Microsoft SQL Server ODBC has an
	// inherent limitation in that you cannot
	// issue a command to the database when there
	// is an open rowset, we'll have to open a
	// *NEW* connection and pass that object to
	// our sdo_updater. With a database like
	// Oracle, you would just pass the main
	// sdo_connection object to the updater.
	
	sdo_connection temp_connection;
	temp_connection.open_session("SQL_Pubs","sa","");

	sdo_updater updater(&temp_connection,"sales");

	// pass all the new values to the updater object
	// specify column names as shown, with the
	// corresponding new values
	updater["stor_id"]<<_store_id;
	updater["ord_num"]<<_order_number;
	updater["ord_date"]<<_order_date;
	updater["qty"]<<_quantity;
	updater["payterms"]<<_payment_terms;
	updater["title_id"]<<_title_id;;

	// create an sdo_where object so we can
	// pass the primary key values that specify
	// this particular record.
	sdo_where where;
	where.Format(
		"stor_id='%s' AND ord_num='%s' AND title_id='%s'"
		,_store_id
		,_order_number
		,_title_id
		);

	// insert the where clause into the updater
	updater<<where;

	// now execute the statement on the connection
	updater.execute();

	// that's all there is to it! but to be 
	// nice, we can force a refresh of the view
	OnRefresh();
}

BOOL CFormDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// here we'll call OnNext so the first
	// record will be displayed when the
	// dialog is initially displayed
	OnNext();

	return TRUE;
}

void CFormDlg::OnInsert() 
{
	// first lets update our
	// dialog variables
	UpdateData(TRUE);

	// an sdo_inserter object takes
	// the a pointer to the sdo_connection
	// object, and the name of the table as
	// parameters

	// NOTE TO MS SQL SERVER USERS:
	// since Microsoft SQL Server ODBC has an
	// inherent limitation in that you cannot
	// issue a command to the database when there
	// is an open rowset, we'll have to open a
	// *NEW* connection and pass that object to
	// our sdo_inserter. With a database like
	// Oracle, you would just pass the main
	// sdo_connection object to the inserter.
	
	sdo_connection temp_connection;
	temp_connection.open_session("SQL_Pubs","sa","");

	sdo_inserter inserter(&temp_connection,"sales");

	// pass all the new values to the inserter object
	// specify column names as shown, with the
	// corresponding new values
	inserter["stor_id"]<<_store_id;
	inserter["ord_num"]<<_order_number;
	inserter["ord_date"]<<_order_date;
	inserter["qty"]<<_quantity;
	inserter["payterms"]<<_payment_terms;
	inserter["title_id"]<<_title_id;;

	// now execute the statement on the connection
	inserter.execute();

	// that's all there is to it! but to be 
	// nice, we can force a refresh of the view
	OnRefresh();
}
